package ch.frankel.blog.spring.authoring.custom;

import org.junit.Before;
import org.junit.Test;
import org.mockito.BDDMockito;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.EmptyReaderEventListener;
import org.springframework.beans.factory.parsing.FailFastProblemReporter;
import org.springframework.beans.factory.parsing.NullSourceExtractor;
import org.springframework.beans.factory.parsing.ReaderEventListener;
import org.springframework.beans.factory.support.SimpleBeanDefinitionRegistry;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.core.io.DescriptiveResource;
import org.springframework.core.io.Resource;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

import ch.frankel.blog.spring.authoring.custom.CustomNamespaceHandler;


public class CustomNamespaceHandlerTest {

	private CustomNamespaceHandler handler;

	private ParserContext context;

	private Element element;

	private NamedNodeMap nnm;

	@Before
	public void setUp() throws Exception {

		handler = new CustomNamespaceHandler();

		NullSourceExtractor sourceExtractor = new NullSourceExtractor();

		XmlBeanDefinitionReader xbdr = new XmlBeanDefinitionReader(
				new SimpleBeanDefinitionRegistry());

		ReaderEventListener listener = new EmptyReaderEventListener();

		FailFastProblemReporter ffpr = new FailFastProblemReporter();

		Resource resource = new DescriptiveResource("test");

		XmlReaderContext readerContext = new XmlReaderContext(resource, ffpr,
				listener, sourceExtractor, xbdr, null);

		context = new ParserContext(readerContext,
				new BeanDefinitionParserDelegate(readerContext));

		element = BDDMockito.mock(Element.class);

		nnm = BDDMockito.mock(NamedNodeMap.class);

		BDDMockito.given(element.getAttributes()).willReturn(nnm);

		handler.init();
	}

	@Test
	public void testParseFoo() {

		BDDMockito.given(nnm.getLength()).willReturn(0);

		BDDMockito.given(element.getLocalName()).willReturn("foo");

		// If Spring does not find the definition, it will crash with a
		// BeanDefinitionParsingException
		// No assert is necessary
		handler.parse(element, context);
	}

	@Test
	public void testParseBar() {

		BDDMockito.given(element.getAttribute(AbstractBeanDefinitionParser.ID_ATTRIBUTE))
				.willReturn("something");
		BDDMockito.given(element.getLocalName()).willReturn("bar");

		// If Spring does not find the definition, it will crash with a
		// BeanDefinitionParsingException
		// No assert is necessary
		handler.parse(element, context);
	}

	@Test(expected = BeanDefinitionParsingException.class)
	public void testParseBaz() {

		BDDMockito.given(nnm.getLength()).willReturn(0);

		BDDMockito.given(element.getLocalName()).willReturn("baz");

		handler.parse(element, context);
	}
}
